/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.resample;

import builder.resid.resample.TwoPassSincResampler;
import builder.resid.resample.ZeroOrderResampler;
import libsidplay.common.SamplingMethod;

public interface Resampler {
    public boolean input(int var1);

    public int output();

    public void reset();

    public static Resampler createResampler(double clockFrequency, SamplingMethod method, double samplingFrequency, double highestAccurateFrequency) {
        switch (method) {
            case DECIMATE: {
                return new ZeroOrderResampler(clockFrequency, samplingFrequency);
            }
            case RESAMPLE: {
                return new TwoPassSincResampler(clockFrequency, samplingFrequency, highestAccurateFrequency);
            }
        }
        throw new RuntimeException("Unknown sampling method: " + (Object)((Object)method));
    }
}

